import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;
import java.io.*;
import Brushstroke;

final public class KanaStroke extends Applet implements Runnable, ActionListener, ItemListener
{  Brushstroke _aBrushstrokes[];
   int _iCurrentStroke;
   Image _image;
   int _iSize;
   Thread _thread;
   Label _labelTotal;
   Color _colorBG;

   final static String _strStroke = "Stroke ", _strClear = "Clear";
   final static Color _aColorStroke[] =
   {  new Color(0x80, 0x80, 0x80),
      new Color(0xff, 0x40, 0x40),
      new Color(0x40, 0xff, 0x40),
      new Color(0x40, 0x40, 0xff),
      new Color(0xb0, 0x20, 0xb0),
      new Color(0xb0, 0xb0, 0x20)
   };

   final public void init()
   {  try
      {  _colorBG = new Color(Integer.parseInt(getParameter("bgcolor"), 16));
      }
      catch (Exception e)
      {  _colorBG = Color.white;
      }

      setBackground(_colorBG);
      setLayout(new BorderLayout());

      try
      {  Brushstroke.read(getDocumentBase(), getParameter("file"));
      }
      catch (Exception e)
      {
      }

      _labelTotal = new Label("", Label.CENTER);

      Panel panel = new Panel();
      panel.setLayout(new GridLayout(3, 4));

      for (int iStroke = 1; iStroke <= 6; iStroke++)
      {  Button button = new Button(_strStroke + iStroke);
	 button.addActionListener(this);
	 button.setBackground(_aColorStroke[iStroke - 1]);
	 panel.add(button);
      }

      Button button = new Button(_strClear);
      button.addActionListener(this);
      panel.add(button);

      panel.add(_labelTotal);

      panel.add(new Label("Kana:", Label.RIGHT));
      Choice choice = new Choice();

      String strKana = getParameter("kana");
      if (strKana != null)
      {  StringTokenizer stKana = new StringTokenizer(strKana, ",");
	 while (stKana.hasMoreTokens())
	 {  choice.addItem(stKana.nextToken());
	 }

	 getStroke(choice.getSelectedItem());
      }

      choice.addItemListener(this);
      panel.add(choice);

      panel.add(new Label("Speed:", Label.RIGHT));

      choice = new Choice();
      for (int iSpeed = 1; iSpeed <= 15; iSpeed++)
      {  choice.addItem(String.valueOf(iSpeed));
      }

      choice.select(Brushstroke.speed() - 1);
      choice.addItemListener(this);
      panel.add(choice);

      add(panel, "South");

      Dimension dimWindow = getSize();
      _iSize = Math.min(dimWindow.width,
			dimWindow.height - panel.getPreferredSize().height);
      _image = createImage(_iSize, _iSize);
      Graphics g = _image.getGraphics();
      g.setColor(_colorBG);
      g.fillRect(0, 0, _iSize, _iSize);
      g.dispose();
   }

   final public void paint(Graphics g)
   {  g.drawImage(_image, 0, 0, this);
   }

   final public void stop()
   {  if (_thread != null)
      {  _thread.stop();
      }
   }

   final public void run()
   {  _aBrushstrokes[_iCurrentStroke].draw(_image, this, _aColorStroke[_iCurrentStroke],
					   _iSize, _iSize * 8 / 500);
      _thread = null;
   }

   final private void clearImage()
   {  if (_thread != null)
      {  _thread.stop();
	 _thread = null;
      }

      Graphics g = _image.getGraphics();
      g.setColor(_colorBG);
      g.fillRect(0, 0, _iSize, _iSize);
      g.dispose();
      repaint();
   }

   final public void actionPerformed(ActionEvent ae)
   {  String strCommand = ae.getActionCommand();
      if (strCommand.equals(_strClear))
      {  clearImage();
      }
      else if (strCommand.startsWith(_strStroke))
      {  if (_thread == null)
	 {  int iStroke = strCommand.charAt(strCommand.length() - 1) - '1';
	    if (_aBrushstrokes != null
		&& iStroke < _aBrushstrokes.length)
	    {  _iCurrentStroke = iStroke;
	       (_thread = new Thread(this)).start();
	    }
	 }
      }
   }

   final public void itemStateChanged(ItemEvent ie)
   {  String strItem = (String)ie.getItem();
      try
      {  Brushstroke.setSpeed(Integer.parseInt(strItem));
      }
      catch (Exception e)
      {  clearImage();
	 getStroke(strItem);
      }
   }

   final private void getStroke(String strName)
   {  StringBuffer sb = new StringBuffer();
      if ((_aBrushstrokes = Brushstroke.get(strName)) != null)
      {  sb.append(_aBrushstrokes.length).append(" stroke");
	 if (_aBrushstrokes.length >= 2)
	 {  sb.append('s');
	 }
      }

      _labelTotal.setText(sb.toString());
   }
}
